# List Forge Video Overlay Guide

## Overview

The List Forge Video Overlay allows streamers and content creators to display their current army list state directly in their video stream. The overlay shows:
- **Units** (alive and killed)
- **Stratagems** (when expanded)
- **Army and Detachment Rules** (when expanded)
- **Used Weapons and Abilities** status

The overlay updates in real-time as you interact with your roster in the app, making it perfect for tournament streams, battle reports, and live gameplay.

---

## Requirements

- **List Forge Desktop App** (Windows, macOS, or Linux)
- **OBS Studio** or **vMix** (or other streaming software that supports Browser Sources)
- ListForge Club subscription

---

## Setup Instructions

### Step 1: Enable the Overlay Server

1. Open **List Forge**
2. Navigate to **Settings** (gear icon)
3. Scroll down to the **"Video Overlay"** section
4. Toggle **"Enable Overlay Server"** to ON
5. Wait for the status to show **"Server Running"** (green checkmark)

### Step 2: Copy the Overlay URL

Once the server is running, you'll see:
- **Status**: Server Running ✓
- **Overlay URL**: `http://localhost:8080/overlay.html`

Copy this URL (you'll need it for OBS).

### Step 3: Add to OBS Studio

1. Open **OBS Studio**
2. In your scene, click the **"+"** button in the Sources panel
3. Select **"Browser Source"**
4. Name it (e.g., "List Forge Overlay")
5. In the Browser Source properties:
   - **URL**: Paste `http://localhost:8080/overlay.html`
   - **Width**: `1920` (or your stream resolution width)
   - **Height**: `1080` (or your stream resolution height)
   - **Custom CSS**: Leave empty
6. Click **OK**

### Step 3 (Alternative): Add to vMix

1. Open **vMix**
2. In your Input list, click **"Add Input"** (or press `Ctrl+I`)
3. Click **"More..."** to see additional input options
4. Select **"Web Browser"**
5. Name it (e.g., "List Forge Overlay")
6. In the Web Browser properties:
   - **URL**: Paste `http://localhost:8080/overlay.html`
   - **Width**: `1920` (or your output resolution width)
   - **Height**: `1080` (or your output resolution height)
7. Click **OK**

### Step 4: Add Your Screen Recording (vMix)

Before you can overlay the browser sources, you need your main video input:

1. In vMix, click **"Add Input"**
2. Add your screen recording source:
   - **Desktop Capture** - to capture your entire desktop
   - **Window Capture** - to capture a specific window
   - **Video Capture** - if using a camera
   - Or any other input you want as your base video
3. This will be your main input that the overlays will appear on top of

### Step 5: Set Up Overlays in vMix

To view your Web Browser overlays on top of your screen recording:

1. **Select your main input** (the screen recording) in the Input list - this will be the base video
2. **Activate each overlay source**:
   - Select your first **Web Browser overlay input** in the Input list
   - Click the numbered **Overlay button (1, 2, 3, or 4)** on that Web Browser input - this sets it as an overlay
   - Repeat for each additional Web Browser overlay: select the input, then click a different numbered overlay button (1, 2, 3, or 4) on that input
   - Each overlay button (1-4) can be assigned to a different Web Browser input
   - You can activate multiple overlays at once by clicking different numbered buttons on different overlay sources
3. **Position each overlay**:
   - With an overlay active, select that Web Browser overlay input
   - Click the **Settings** button (gear icon) for that input
   - Go to the **Position** tab
   - Adjust X/Y position, or use the preview to drag and resize
   - The overlay will appear in front of your main video source
4. **Configure overlay settings** (optional):
   - Click the **Overlay** button in the bottom right corner of vMix
   - Set **Duration** to `0` if you want overlays to stay on until you turn them off
   - Adjust other overlay settings as needed

**Note**: Since the Web Browser sources have transparent backgrounds, they'll layer properly over your screen recording without showing the browser's background.

### Step 6: Position the Overlay (OBS)

1. **In OBS**: Select the Browser Source you just created
2. Drag and resize it to position it on your stream
3. The overlay is designed to show:
   - **Player list** on the left side
   - **Opponent list** on the right side (if an opponent list is loaded)

### Step 7: Test the Overlay

1. In List Forge, open a roster in **View Roster** mode
2. The overlay should automatically update to show your units
3. Try expanding/collapsing units, killing units, or using weapons/abilities
4. The overlay should update in real-time (updates every 500ms)

---

## Using the Overlay

### What Gets Displayed

**Player List (Left Side):**
- List name and detachment name at the top
- **Alive Units**: All units that haven't been marked as killed
  - Collapsed: Shows unit name + used weapons/abilities status
  - Expanded: Shows full unit details with all profiles
- **Killed Units**: Units marked as killed (shown in a separate section)
- **Stratagems**: Only shows stratagems that are currently expanded in the app
- **Army/Detachment Rules**: Only shows when the rules section is expanded

**Opponent List (Right Side):**
- Same structure as player list
- Only appears if you've loaded an opponent list using the "View Opponent" feature

### Controlling What's Visible

The overlay reflects exactly what you see in the app:

- **To show a unit's details**: Expand the unit card in List Forge
- **To show a stratagem**: Expand the stratagem in List Forge
- **To show army/detachment rules**: Expand the rules section in List Forge
- **To mark a unit as killed**: Use the kill button in List Forge (unit moves to "Killed Units" section)
- **To show used weapons/abilities**: The overlay automatically shows these when weapons/abilities are marked as used in the app

---

## Stopping the Overlay Server

### Method 1: Via Settings (Recommended)

1. Open **List Forge Settings**
2. Go to **Video Overlay** section
3. Toggle **"Enable Overlay Server"** to OFF
4. The server will stop and the status will show "Server Not Running"

### Method 2: Close List Forge

Closing the List Forge app will automatically stop the overlay server.

---

## Troubleshooting

### Overlay Not Showing in OBS/vMix

**Problem**: Browser Source shows blank or error message

**Solutions**:
1. Verify the overlay server is running in List Forge Settings
2. Check that the URL is exactly: `http://localhost:8080/overlay.html`
3. **In OBS**: Try refreshing the Browser Source (right-click → Refresh)
4. **In vMix**: Right-click the Web Browser input → **Refresh** (or restart the input)
5. Make sure List Forge is running and you have a roster open in View mode

### Overlay Not Updating

**Problem**: Overlay shows old data or doesn't change when you interact with the app

**Solutions**:
1. The overlay updates every 500ms - wait a moment for changes to appear
2. Make sure you're viewing a roster in the app (not editing)
3. **In OBS**: Try refreshing the Browser Source (right-click → Refresh)
4. **In vMix**: Right-click the Web Browser input → **Refresh**
5. Check that the overlay server status shows "Server Running"

### "Failed to Start Server" Error

**Problem**: Server won't start, shows error message

**Solutions**:
1. Port 8080 might be in use by another application
2. Close any other applications using port 8080
3. Restart List Forge and try again
4. If the problem persists, restart your computer

### Overlay Shows "No player list loaded"

**Problem**: Overlay displays empty state message

**Solutions**:
1. Make sure you have a roster open in **View Roster** mode (not Edit mode)
2. The overlay only works when viewing a roster, not when editing
3. Navigate to View Roster screen in the app

### Overlay Appears Too Small or Too Large

**Problem**: Overlay size doesn't match your stream resolution

**Solutions**:
1. **In OBS**: In Browser Source properties, set:
   - **Width**: Match your canvas/stream width (e.g., 1920)
   - **Height**: Match your canvas/stream height (e.g., 1080)
2. **In vMix**: In Web Browser input properties, set:
   - **Width**: Match your output width (e.g., 1920)
   - **Height**: Match your output height (e.g., 1080)
3. Resize the source by dragging the corners in your streaming software
4. The overlay is responsive and will scale to fit the Browser Source size

---

## Tips for Streamers

### Best Practices

1. **Position the overlay on screen edges** to avoid covering important gameplay
2. **Use the transparent background** - the overlay has a transparent background by default, perfect for overlaying on gameplay
3. **Expand only what you need** - the overlay only shows expanded items, so keep things collapsed unless viewers need to see the details
4. **Test before going live** - set up and test the overlay before your stream starts
5. **Keep List Forge open** - the overlay requires List Forge to be running with a roster open

### Layout Suggestions

- **Left side**: Position player list on the left edge, top or bottom
- **Right side**: Position opponent list on the right edge (if using opponent view)
- **Top or bottom**: You can also position the overlay at the top or bottom of the screen
- **Corner placement**: The List Forge logo appears in the bottom-right corner

### Performance

- The overlay updates every 500ms for smooth real-time updates
- Minimal performance impact on your stream
- The overlay server runs locally on your computer (localhost)

---

## Using with Discord Screen Share

### Option 1: OBS Virtual Camera (Recommended - Discord Desktop App)

**This is the recommended method for streaming with Discord Desktop App. It provides the best quality and control.**

1. **Set up OBS with the overlay** (follow Steps 1-4 in Setup Instructions above)

2. **Add your game to OBS**:
   - In OBS, click the **"+"** button in Sources
   - Add **"Game Capture"** or **"Window Capture"** to capture your game
   - Position the game capture source behind the overlay
   - The overlay will appear on top of the game

3. **Start OBS Virtual Camera**:
   - In OBS Studio, click the **"Start Virtual Camera"** button (usually in the Controls panel at the bottom)
   - The virtual camera will now be active
   - You should see "Virtual Camera: Active" in OBS

4. **Use in Discord Desktop App**:
   - **For Screen Share**: In Discord, click **"Share Your Screen"** → Select **"OBS Virtual Camera"** from the application list
   - **For Video**: In Discord, go to **User Settings** → **Voice & Video** → Under **Camera**, select **"OBS Virtual Camera"** from the dropdown
   - Your game with the overlay will now appear in Discord

**Troubleshooting OBS Virtual Camera**:
- **Can't find OBS Virtual Camera**: Make sure OBS Virtual Camera is started in OBS first, and you're using Discord Desktop App (not web)
- **Not showing in Discord**: Try restarting Discord after starting OBS Virtual Camera
- **Using Discord Web**: OBS Virtual Camera doesn't work with Discord web - use Option 2 instead

**Pros**: Best quality, full control over positioning, can composite multiple sources (overlay + webcam, etc.), works as a camera source, clean output without OBS interface  
**Cons**: Requires OBS setup, requires Discord Desktop App

**Note**: You can also use OBS Virtual Camera for other video conferencing apps (Zoom, Teams, etc.)

### Option 2: Share OBS Preview Window (Discord Web)

**Use this method if you're using Discord web (browser version).**

1. **Set up OBS with the overlay** (follow Steps 1-4 in Setup Instructions above)

2. **Add your game to OBS**:
   - In OBS, click the **"+"** button in Sources
   - Add **"Game Capture"** or **"Window Capture"** to capture your game
   - Position the game capture source behind the overlay
   - The overlay will appear on top of the game

3. **Enable OBS Preview**:
   - In OBS Studio, go to **View** → **Preview** (if not already visible)
   - The preview window will show your game with the overlay on top

4. **Share OBS window in Discord**:
   - In Discord web, click **"Share Your Screen"** or **"Go Live"**
   - Select the **OBS Studio** window from the application list
   - Your game with the overlay will now appear in Discord

**Tip**: To hide the OBS interface, you can use **View** → **Fullscreen Projector** → **Preview** to get a clean view of just your scene.

**Pros**: Works with Discord web, shows game + overlay together, full control over positioning  
**Cons**: Requires OBS setup, shows OBS interface unless you use fullscreen preview

---

## Advanced: Custom Port

By default, the overlay server runs on port **8080**. If you need to use a different port:

1. This feature may be added in a future update
2. Currently, port 8080 is hardcoded
3. If port 8080 is unavailable, close the application using it and restart List Forge

---

## Support

If you encounter issues not covered in this guide:

1. Check that you're using the latest version of List Forge
2. Ensure OBS Studio or vMix is up to date
3. Verify your roster is in View mode (not Edit mode)
4. Try restarting both List Forge and your streaming software

---

## Quick Reference

| Action | Steps |
|--------|-------|
| **Start Overlay** | Settings → Video Overlay → Enable Overlay Server |
| **Get URL** | Copy `http://localhost:8080/overlay.html` from Settings |
| **Add to OBS** | Add Browser Source → Paste URL → Set size |
| **Add to vMix** | Add Input → Web Browser → Paste URL → Set size |
| **Activate in vMix** | Select main input → Click Overlay buttons (1-4) → Select Web Browser input |
| **Stop Overlay** | Settings → Video Overlay → Disable Overlay Server |
| **Update Overlay** | Interact with roster in View mode (auto-updates) |

---

**Happy Streaming! 🎮📺**
